///////////////////////////////////////////////////////////////////////
//
//
//     FILE : TOOLST01.JS
//
//     DESCRIPTION :     This file contains a set of objects that will help
//                         in the manipulation of data, browser determination,
//                         and timing functions.
//
//     DEPENDENCIES :     This script has no dependencies on any other scripts.
//
//     CREATED :          04/13/2002, Richard Forrester x56066
//     LAST UPDATED :     08/09/2002, Richard Forrester x56066
//
//     COPYWRITE :          IBM Corporation 2002
//
///////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////APPLICATION OBJECTS///////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////

//********************************************************************
//********************************************************************
//     OBJECT :     Browser
//
//     DESCRIPTION :     This object will determine what browser is being
//                         used to view the HTML document.
//********************************************************************
//********************************************************************
function Browser(parent)
{
     // Member Variables
     this.appVersion = navigator.appVersion;
     this.name = navigator.appName;
     this.appCodeName = navigator.appCodeName;
     this.language = navigator.language;
     this.platform = navigator.platform;
     this.version = parseInt(this.appVersion.substring(0,this.appVersion.indexOf(".")));
     this.release = parseInt(this.appVersion.substring(2,this.appVersion.indexOf(" ")));
     this.compatable = this.appVersion.substring(this.appVersion.indexOf(" ")+1);
     this.isNS = (this.name == "Netscape") ? true : false;
     this.isIE = (this.name.indexOf("Microsoft") != -1) ? true : false;
     this.isOther = (!this.isNS && !this.isIE) ? true : false; 
     this.isNS4 = false;
     this.isIE4 = false;
     this.isNS6 = false;
     this.isIE7 = false;
     this.isNS404 = false;
     this.parent = parent;

     if (this.version == 4)
     {
          this.isNS4 = (this.isNS) ? true : false;
          this.isIE5 = (this.isIE) ? true : false;
     }
     
     if (this.version == 5)
     {
          this.isNS6 = (this.isNS) ? true : false;
          this.isIE7 = (this.isIE) ? true : false;
     }

     if ((this.isNS) && (this.version == 4) && (this.release == 4)) this.isNS404 = true;
}

//********************************************************************
//********************************************************************
//     OBJECT :          WorkingDocument
//
//     DESCRIPTION :     This object will get pertinant work area
//                         information.  ie: screen coordinates,scroll
//                         positions, document height, ect...
//********************************************************************
//********************************************************************

function WorkingDocument(parent)
{
     // member functions
     this.getTop = WorkingDocumentTop;
     this.getLeft = WorkingDocumentLeft;
     this.getWidth = WorkingDocumentWidth;
     this.getHeight = WorkingDocumentHeight;
     
     // member variables
     if ( parent == null ) 
     {
          this.parent = new Object();
          this.parent.browser = new Browser();
     }
     else this.parent = parent;
     
     if ( !this.parent.browser ) this.parent.browser = new Browser();
}

function WorkingDocumentTop()
{
     return (this.parent.browser.isNS) ? window.pageYOffset : document.body.scrollTop;
}

function WorkingDocumentLeft()
{
     return (this.parent.browser.isNS) ? window.pageXOffset : document.body.scrollLeft;
}

function WorkingDocumentWidth()
{
     return (this.parent.browser.isNS) ? document.width : document.body.scrollWidth;
}

function WorkingDocumentHeight()
{
     return (this.parent.browser.isNS) ? document.height : document.body.scrollHeight;
}

//********************************************************************
//********************************************************************
//     OBJECT :          Display
//
//     DESCRIPTION :     This object will get the physical attributes of
//                         the work area window.  Width/height of the screen.
//********************************************************************
//********************************************************************

function Display(parent)
{
     // member functions
     this.getWidth = DisplayWidth;
     this.getHeight = DisplayHeight;
     
     // member variables
     if ( parent == null ) 
     {
          this.parent = new Object();
          this.parent.browser = new Browser();
     }
     else this.parent = parent;
     
     if ( !this.parent.browser ) this.parent.browser = new Browser();
}

function DisplayWidth()
{
     return (this.parent.browser.isNS) ? window.innerWidth : document.body.clientWidth;
}

function DisplayHeight()
{
     return (this.parent.browser.isNS) ? window.innerHeight : document.body.clientHeight;
}

//********************************************************************
//********************************************************************
//     OBJECT :     Cookie
//
//     DESCRIPTION :     This object will create, and read cookies.
//********************************************************************
//********************************************************************

function Cookie(parent)
{
     // Public Member Functions
     this.getValue = CookieGetValue;
     this.getOffset = CookieGetOffset;
     this.setDate = CookieSetDate;
     this.setPath = CookieSetPath;
     this.setDomain = CookieSetDomain;
     this.setSecurity = CookieSetSecurity;
     this.setValue = CookieSetValue;
     this.load = CookieLoad;
     this.create = CookieCreate;
     this.save = CookieSave;
     this.remove = CookieDelete;
     
     // Private Member Functions
     this.fixDate = CookieFixDate;

     // Private Member Variables
     this.cname = "";
     this.value = "";
     this.date = null;
     this.domain = "";
     this.path = "";
     this.security = false;
     this.valid = false;
     this.parent = parent;
}

function CookieGetValue()
{
     return this.value;
}

function CookieGetOffset(offset,length)
{
     return this.value.substr(offset,length);
}

function CookieSetDate(date)
{
     this.date = (date) ? "; expires=" + date.toGMTString() : "";
//     this.fixDate();
}

function CookieFixDate()
{
     var base = new Date(0);
     var skew = base.getTime();
     if (skew > 0)
     {
          this.date.setTime(this.date.getTime() - skew);
     }
}

function CookieSetPath(path)
{
     this.path = (path) ? "; path=" + path : "";
}

function CookieSetDomain(domain)
{
     this.domain = (domain) ? "; domain=" + domain : "";
}

function CookieSetSecurity(secure)
{
     this.security = (secure) ? "; secure" : "";
}

function CookieLoad(name)
{
     this.cname = name;
     var theName = name + "=";
     var NameLen = theName.length;
     var CookieLen = document.cookie.length;
     var offset = 0;
     var Result = false;
     for (var i = 0; i < CookieLen; i++ )
     {
          offset = i + NameLen;
          if ( document.cookie.substring(i,offset) == theName )
          {
               var CookieEnd = document.cookie.indexOf (";", offset);
               if (CookieEnd == -1)
                   CookieEnd = document.cookie.length;
               this.value = unescape(document.cookie.substring(offset, CookieEnd));
               Result = true;
               this.valid = true;
          }
          
          i = document.cookie.indexOf(" ", i);
          if ( i == -1 ) break;
     }
     
     return Result;
}

function CookieCreate(name,value,expires,path,domain,secure)
{
     this.cname = name;
     this.value = value;
     this.setDate(expires);
     this.setPath(path);
     this.setDomain(domain); 
     this.setSecurity(secure);
     
     document.cookie = this.cname + "=" + escape(this.value) +
                           this.date + this.path + this.domain +
                           this.security;
                          
     this.valid = true;
}

function CookieSave()
{
     document.cookie = this.cname + "=" + escape(this.value) +
                           this.date + this.path + this.domain +
                           this.security;
}

function CookieDelete()
{
     if (this.valid) 
     {
          document.cookie = this.cname + "=" +
                                ((this.path) ? "; path=" + path : "") +
                                ((this.domain) ? "; domain=" + domain : "") +
                                "; expires=Thu, 01-Jan-70 00:00:01 GMT";
     }
}

function CookieSetValue(value)
{
     this.value = value
}

//********************************************************************
//********************************************************************
//     OBJECT :          Application
//
//     DESCRIPTION :     This object is a combination of all the objects
//                         described above in this section.  A Central place
//                         to get all types.
//********************************************************************
//********************************************************************

function Application()
{
     // member functions
     this.getCookie = ApplicationGetCookie;
     this.setCookie = ApplicationSetCookie;
     this.createCookieObject = ApplicationCreatCookieObj;
     this.getMouseX = ApplicationMouseX;
     this.getMouseY = ApplicationMouseY;
     
     // member variables
     this.browser = new Browser(this);
     this.workingDocument = new WorkingDocument(this);
     this.display = new Display(this);
}

function ApplicationGetCookie(cName)
{
     var cookie = new Cookie(this);
     
     if ( cookie.load(cName) ) return cookie;
     else return null;
}

function ApplicationSetCookie(name,value,expires,path,domain,secure)
{
     var cookie = new Cookie(this);
     
     cookie.create(name,value,expires,path,domain,secure);
}

function ApplicationCreatCookieObj()
{
     return new Cookie(this);
}

function ApplicationMouseX()
{
     return docEvent.point.x;
}

function ApplicationMouseY()
{
     return (this.browser.isNS) ? docEvent.point.y : (docEvent.point.y + this.workingDocument.getTop());
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////Event OBJECTS/////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////


//********************************************************************
//********************************************************************
//     OBJECT :     Timer
//
//     DESCRIPTION :     This object is for setting Timer type functions.
//                         There are two types of timers that can be used:
//                              1)  Single Timer
//                              2)  Interval Timer
//********************************************************************
//********************************************************************

// Timer types
Timer.SINGLE_TIMER = 0;
Timer.INTERVAL_TIMER = 1;

// global tracking
Timer.index = 0;
Timer.all = new Array();

function Timer(type)
{
     // member functions
     this.setTimerType = TimerSetTimerType;
     this.setTimer = TimerSetTimer;
     this.stopTimer = TimerStopTimer;
     this.startTimer = TimerStartTimer;
     this.isTimerRunning = TimerIsTimerRunning;
     
     // member variables
     this.name = "Timer" + Timer.index++;
     this.obj = this.name;
     this.type = (type) ? type : Timer.SINGLE_TIMER;
     this.time = 0;
     this.timerId = -1;
     this.fnPtr = null;
     this.timerRunning = false;
     
     // set global attributes
     eval(this.obj + " = this;");
     Timer.all[Timer.all.length] = this;
}

function TimerSetTimerType(type)
{
     // set the timer type
     this.type = type;
}

function TimerSetTimer(ms,fnStr)
{
     // set the time
     this.time = ms;
     
     // create a function and set fnStr inside function
     this.fnPtr = new Function(fnStr);
}

function TimerStopTimer()
{
     // if timer is INTERVAL_TIMER stop the timer using timerId
     if ( this.type == Timer.INTERVAL_TIMER )
     {
          clearInterval(this.timerId);
          this.timerRunning = false;
     }
}

function TimerStartTimer()
{
     if ( this.type == Timer.INTERVAL_TIMER )
     {
          // timer is INTERVAL_TIMER create interval and set timerID
          this.timerId = setInterval(this.obj + ".fnPtr()",this.time);
          this.timerRunning = true;
     }
     else
     {
          // timer is SINGLE_TIMER create timeout
          setTimeout(this.obj + ".fnPtr()",this.time);
     }
}

function TimerIsTimerRunning()
{
     return this.timerRunning;
}


//********************************************************************
//********************************************************************
//     OBJECT :          EventScheduler
//
//     DESCRIPTION :     This file contains the event scheduler object. When
//                         any HTML element needs an event to be scheduled based
//                         on mouse events, focus events, load events
//********************************************************************
//********************************************************************

// Types of events
EventScheduler.MOUSE_MOVE = 0;
EventScheduler.MOUSE_OVER = 1;
EventScheduler.MOUSE_OUT = 2;
EventScheduler.MOUSE_DOWN = 3;
EventScheduler.MOUSE_UP = 4;
EventScheduler.MOUSE_CLICK = 5;
EventScheduler.FOCUS = 6;
EventScheduler.BLUR = 7;
EventScheduler.LOAD = 8;
EventScheduler.UNLOAD = 9;

// tracking variables
EventScheduler.index = 0;
EventScheduler.all = new Array();
docEvent = new EventScheduler(document);
docEvent.setEvent(EventScheduler.MOUSE_MOVE,null);

function EventScheduler(element)
{
     // member functions
     this.setEvent = EventSchedulerSetEvent;
     this.stopEvent = EventSchedulerStopEvent;
     this.startEvent = EventSchedulerStartEvent;
     this.removeEvent = EventSchedulerRemoveEvent;
     this.onMouseMove = EventSchedulerOnMouseMove;
     this.onMouseOver = EventSchedulerOnMouseOver;
     this.onMouseOut = EventSchedulerOnMouseOut;
     this.onMouseDown = EventSchedulerOnMouseDown;
     this.onMouseUp = EventSchedulerOnMouseUp;
     this.onClick = EventSchedulerOnClick;
     this.onFocus = EventSchedulerOnFocus;
     this.onBlur = EventSchedulerOnBlur;
     this.onLoad = EventSchedulerOnLoad;
     this.onUnload = EventSchedulerOnUnload;

     // member variables
     this.element = element;
     this.fnPtr = new Array(null,null,null,null,null,null,null,null,null);
     this.name = "EventScheduler" + EventScheduler.index++;
     this.obj = this.name;
     this.point = new Object();
     this.point.x = 0;
     this.point.y = 0;
     this.b = new Browser();

     // set a global variable for this object
     eval(this.obj + " = this");
     
     // add this object to the tracking variable
     EventScheduler.all[EventScheduler.all.length] = this;
}

function EventSchedulerSetEvent(eventType,fnStr)
{
     // set the function pointer for event
     this.fnPtr[eventType] = new Function(fnStr);
     
     // set the event object for the element
     this.element.eventObj = this;
     
     // if in netscape capture the events
     if ( this.b.isNS4 )
     {
          if ( eventType == EventScheduler.MOUSE_MOVE) this.element.captureEvents(Event.MOUSEMOVE);
          if ( eventType == EventScheduler.MOUSE_OVER) this.element.captureEvents(Event.MOUSEOVER);
          if ( eventType == EventScheduler.MOUSE_OUT) this.element.captureEvents(Event.MOUSEOUT);
          if ( eventType == EventScheduler.MOUSE_DOWN) this.element.captureEvents(Event.MOUSEDOWN);
          if ( eventType == EventScheduler.MOUSE_UP) this.element.captureEvents(Event.MOUSEUP);
          if ( eventType == EventScheduler.MOUSE_CLICK) this.element.captureEvents(Event.CLICK);
          if ( eventType == EventScheduler.FOCUS) this.element.captureEvents(Event.FOCUS);
          if ( eventType == EventScheduler.BLUR) this.element.captureEvents(Event.BLUR);
          if ( eventType == EventScheduler.LOAD) this.element.captureEvents(Event.LOAD);
          if ( eventType == EventScheduler.UNLOAD) this.element.captureEvents(Event.UNLOAD);
     }

     // select type of event
     if ( eventType == EventScheduler.MOUSE_MOVE) this.element.onmousemove = eval(this.obj + ".onMouseMove;");
     if ( eventType == EventScheduler.MOUSE_OVER) this.element.onmouseover = eval(this.obj + ".onMouseOver;");
     if ( eventType == EventScheduler.MOUSE_OUT) this.element.onmouseout = eval(this.obj + ".onMouseOut;");
     if ( eventType == EventScheduler.MOUSE_DOWN) this.element.onmousedown = eval(this.obj + ".onMouseDown;");
     if ( eventType == EventScheduler.MOUSE_UP) this.element.onmouseup = eval(this.obj + ".onMouseUp;");
     if ( eventType == EventScheduler.MOUSE_CLICK) this.element.onclick = eval(this.obj + ".onClick;");
     if ( eventType == EventScheduler.FOCUS) this.element.onfocus = eval(this.obj + ".onFocus;");
     if ( eventType == EventScheduler.BLUR) this.element.onblur = eval(this.obj + ".onBlur;");
     if ( eventType == EventScheduler.LOAD) this.element.onload = eval(this.obj + ".onLoad;");
     if ( eventType == EventScheduler.UNLOAD) this.element.onunload = eval(this.obj + ".onUnload;");
}

function EventSchedulerStopEvent(eventType)
{
     // select the type of event
     if ( eventType == EventScheduler.MOUSE_MOVE) this.element.onmousemove = null;

     if ( eventType == EventScheduler.MOUSE_OVER) this.element.onmouseover = null;

     if ( eventType == EventScheduler.MOUSE_OUT) this.element.onmouseout = null;

     if ( eventType == EventScheduler.MOUSE_DOWN) this.element.onmousedown = null;

     if ( eventType == EventScheduler.MOUSE_UP) this.element.onmouseup = null;

     if ( eventType == EventScheduler.MOUSE_CLICK) this.element.onclick = null;

     if ( eventType == EventScheduler.FOCUS) this.element.onfocus = null;

     if ( eventType == EventScheduler.BLUR) this.element.onblur = null;

     if ( eventType == EventScheduler.LOAD) this.element.onload = null;

     if ( eventType == EventScheduler.UNLOAD) this.element.onunload = null;
}

function EventSchedulerStartEvent(eventType)
{
     // select the type of event
     if ( eventType == EventScheduler.MOUSE_MOVE) this.element.onmousemove = eval(this.obj + ".onMouseMove;");

     if ( eventType == EventScheduler.MOUSE_OVER) this.element.onmouseover = eval(this.obj + ".onMouseOver;");

     if ( eventType == EventScheduler.MOUSE_OUT) this.element.onmouseout = eval(this.obj + ".onMouseOut;");

     if ( eventType == EventScheduler.MOUSE_DOWN) this.element.onmousedown = eval(this.obj + ".onMouseDown;");

     if ( eventType == EventScheduler.MOUSE_UP) this.element.onmouseup = eval(this.obj + ".onMouseUp;");

     if ( eventType == EventScheduler.MOUSE_CLICK) this.element.onclick = eval(this.obj + ".onClick;");

     if ( eventType == EventScheduler.FOCUS) this.element.onfocus = eval(this.obj + ".onFocus;");

     if ( eventType == EventScheduler.BLUR) this.element.onblur = eval(this.obj + ".onBlur;");

     if ( eventType == EventScheduler.LOAD) this.element.onload = eval(this.obj + ".onLoad;");

     if ( eventType == EventScheduler.UNLOAD) this.element.onunload = eval(this.obj + ".onUnload;");
}

function EventSchedulerRemoveEvent(eventType)
{
     // clear the function pointer
     this.fnPtr[eventType] = null;

     // select the type of event
     this.stopEvent(eventType);
}

function EventSchedulerOnMouseMove(e)
{
     // extract the page or element location from the event
     this.eventObj.point.x = ( this.eventObj.b.isNS ) ? e.pageX : event.x;
     this.eventObj.point.y = ( this.eventObj.b.isNS ) ? e.pageY : event.y;
     
     // fire off event function pointer
     if ( this.eventObj.fnPtr[EventScheduler.MOUSE_MOVE] != null ) this.eventObj.fnPtr[EventScheduler.MOUSE_MOVE]();
}

function EventSchedulerOnMouseOver(e)
{
     // extract the page or element location from the event
     this.eventObj.point.x = ( this.eventObj.b.isNS ) ? e.pageX : event.x;
     this.eventObj.point.y = ( this.eventObj.b.isNS ) ? e.pageY : event.y;

     // fire off event function pointer
     if ( this.eventObj.fnPtr[EventScheduler.MOUSE_OVER] != null ) this.eventObj.fnPtr[EventScheduler.MOUSE_OVER]();
}

function EventSchedulerOnMouseOut(e)
{
     // extract the page or element location from the event
     this.eventObj.point.x = ( this.eventObj.b.isNS ) ? e.pageX : event.x;
     this.eventObj.point.y = ( this.eventObj.b.isNS ) ? e.pageY : event.y;

     // fire off event function pointer
     if ( this.eventObj.fnPtr[EventScheduler.MOUSE_OUT] != null ) this.eventObj.fnPtr[EventScheduler.MOUSE_OUT]();
}

function EventSchedulerOnMouseDown(e)
{
     // extract the page or element location from the event
     this.eventObj.point.x = ( this.eventObj.b.isNS ) ? e.pageX : event.x;
     this.eventObj.point.y = ( this.eventObj.b.isNS ) ? e.pageY : event.y;

     // fire off event function pointer
     if ( this.eventObj.fnPtr[EventScheduler.MOUSE_DOWN] != null ) this.eventObj.fnPtr[EventScheduler.MOUSE_DOWN]();
}

function EventSchedulerOnMouseUp(e)
{
     // extract the page or element location from the event
     this.eventObj.point.x = ( this.eventObj.b.isNS ) ? e.pageX : event.x;
     this.eventObj.point.y = ( this.eventObj.b.isNS ) ? e.pageY : event.y;

     // fire off event function pointer
     if ( this.eventObj.fnPtr[EventScheduler.MOUSE_UP] != null ) this.eventObj.fnPtr[EventScheduler.MOUSE_UP]();
}

function EventSchedulerOnClick(e)
{
     // fire off event function pointer
     if ( this.eventObj.fnPtr[EventScheduler.MOUSE_CLICK] != null ) this.eventObj.fnPtr[EventScheduler.MOUSE_CLICK]();
}

function EventSchedulerOnFocus(e)
{
     // fire off event function pointer
     if ( this.eventObj.fnPtr[EventScheduler.FOCUS] != null ) this.eventObj.fnPtr[EventScheduler.FOCUS]();
}

function EventSchedulerOnBlur(e)
{
     // fire off event function pointer
     if ( this.eventObj.fnPtr[EventScheduler.BLUR] != null ) this.eventObj.fnPtr[EventScheduler.BLUR]();
}

function EventSchedulerOnLoad(e)
{
     // fire off event function pointer
     if ( this.eventObj.fnPtr[EventScheduler.LOAD] != null ) this.eventObj.fnPtr[EventScheduler.LOAD]();
}

function EventSchedulerOnUnload(e)
{
     // fire off event function pointer
     if ( this.eventObj.fnPtr[EventScheduler.UNLOAD] != null ) this.eventObj.fnPtr[EventScheduler.UNLOAD]();
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////STRING OBJECTS////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////


//********************************************************************
//********************************************************************
//     OBJECT :     StringParser
//
//     DESCRIPTION :     This object parses a string into tokens.  The tokens
//                         are accessable through object functions.
//********************************************************************
//********************************************************************

function StringParser(theString,theDelimeter)
{
     // member functions
     this.parse = StringParserParse;
     this.setString = StringParserSetString;
     this.setDelimeter = StringParserSetDelimeter;
     this.getTokens = StringParserGetTokens;
     this.getNumberOfTokens = StringParserGetNumberOfTokens;
     this.getTokenAt = StringParserGetTokenAt;
     this.getNextToken = StringParserGetNextToken;
     this.EOT = StringParserEndOfTokens;
     this.resetIndex = StringParserResetIndex;
     
     // member variables
     this.parseString = theString;
     this.delimeter = theDelimeter;
     this.tokenIndex = 0;
     this.tokens = new Array();
     
     // If the parse string and delimeter are present, parse the string
     if ( this.parseString && this.delimeter ) this.parse();
}

function StringParserParse(theString,theDelimeter)
{
     var parsingString = null;
     
     // if the argument list is zero 
     if ( arguments.length == 0 ) 
     {
          // check validity of parseString and delimeter
          if ( (this.parseString == null) && (this.delimeter == null) ) alert("ERROR!  No valid parse string or delimeter!");
          else parsingString = this.parseString;
     }
     else
     {
          // set the parse stirng in a local variable
          parsingString = this.parseString = theString;
          this.delimeter = theDelimeter;
     }
     
     // while the delimeter is found in local variable
     while ( parsingString.indexOf(this.delimeter) >= 0 )
     {
          // pull out token to the left of delimeter
          var token = parsingString.substr(0,parsingString.indexOf(this.delimeter));

          // place token in token array
          if ( token.length > 0 ) this.tokens[this.tokens.length] = token;

          // update local variable without token or delimeter     
          parsingString = parsingString.substr(parsingString.indexOf(this.delimeter) + this.delimeter.length);
     }
     
     if ( parsingString.length > 0 ) this.tokens[this.tokens.length] = parsingString;
}

function StringParserSetString(theString)
{
     // set the parseString variable to the given string
     this.parseString = theString;
}

function StringParserSetDelimeter(theDelimeter)
{
     // set the delimeter variable to the given string
     this.delimeter = theDelimeter;
}

function StringParserGetTokens()
{
     // return the array of tokens
     return this.tokens;
}

function StringParserGetNumberOfTokens()
{
     // return the length of the array of tokens
     return this.tokens.length;
}

function StringParserGetTokenAt(index)
{
     var token = null;
     // return the individual token at the given index
     // if the given index is incorrect, give error message
     if ( (index < this.tokens.length) && (index >= 0) ) token = this.tokens[index];
     else alert("Invalid index! Can not get token!");
     
     return token;
}

function StringParserGetNextToken()
{
     var token = null;
     
     // check the variable index for valid index
     if ( (this.tokenIndex < this.tokens.length) && (this.tokenIndex >= 0) )
     {
          // if valid return the token at that index
          token = this.tokens[this.tokenIndex];
          
          // increase index value by 1
          this.tokenIndex++;
     }
     else alert("Invalid Index! Index is out of range!");
     
     return token;
}

function StringParserEndOfTokens()
{
     var bEndOfTokens = false;
     
     // check the variable index of valid index
     if ( (this.tokenIndex >= this.tokens.length) || (this.tokenIndex < 0) ) bEndOfTokens = true;
     
     return bEndOfTokens;
}

function StringParserResetIndex()
{
     // set index to beginning of token array
     this.tokenIndex = 0;
}

//********************************************************************
//********************************************************************
//     OBJECT :     StringManipulator
//
//     DESCRIPTION :     This object is a list of functions that can be
//                         performed on a string.
//********************************************************************
//********************************************************************
function StringManipulator(str)
{
     this.replace = StringManipulatorReplace;
     this.parse = StringManipulatorParse;
     this.isInteger = StringManipulatorIsInteger;
     this.extractIntegers = StringManipulatorExtractIntegers;
     
     this.theString = str;
}

function StringManipulatorReplace(OriginalString,OldString,NewString)
{
     // The new string that will corrected with the replace
     var theString = OriginalString;
     
     // While we find the old string within the new string
     while ( theString.indexOf(OldString) != -1 )
     {
          // remove the old string and replace it with the new string
          theString = theString.substr(0,theString.indexOf(OldString)) + NewString + theString.substring(theString.indexOf(OldString)+ OldString.length);
     }
     
     // return the new string
     return theString;
}

function StringManipulatorParse(theString,theDelimeter)
{
     return new StringParser(theString,theDelimeter);
}

function StringManipulatorIsInteger(str)
{
     var bIsInteger = true;

     if ( str ) this.theString = str;
     
     if ( this.theString )
     {
          for ( var i = 0; i < this.theString.length; i++ )
          {
               var code = this.theString.charCodeAt(i);
               
               if ( (code < 48) || (code > 58) ) 
               {
                    bIsInteger = false;
                    break;
               }
          }
          
     }
     
     return bIsInteger;
}

function StringManipulatorExtractIntegers(str)
{
     var theIntegers = null;
     
     if ( str ) this.theString = str;
     
     if ( this.theString )
     {
          var temp = this.theString;
          var start = 0;
          var stop = 0;
          
          while ( temp )
          {
               var bFoundStart = false;
               
               for ( var i = start; i < this.theString.length; i++ )
               {
                    var code = this.theString.charCodeAt(i);
                    
                    if ( ((code < 48) || (code > 58)) && bFoundStart ) 
                    {
                         stop = i;
                         i = this.theString.length;
                    }
                    else if ( !bFoundStart && (code >= 48) && (code <= 58) ) 
                    {
                         bFoundStart = true;
                         start = i;
                    } 
               }
               
               if ( start != stop ) 
               {
                    if ( !theIntegers ) theIntegers = new Array();
                    theIntegers[theIntegers.length] = parseInt(temp.substr(start,stop));
               }
               else temp = null;
               
               start = stop + 1;
               stop = stop + 1;
               
          }          
     }
     
     return theIntegers;
}

//********************************************************************
//********************************************************************
//     OBJECT :     UrlBuilder
//
//     DESCRIPTION :     This object will build a url.  It builds regular
//                         or query URLs.
//********************************************************************
//********************************************************************

function UrlBuilder(baseUrl)
{
     // member functions
     this.setBase = UrlBuilderSetBase;
     this.setDirectory = UrlBuilderSetDirectory;
     this.setPage = UrlBuilderSetPage;
     this.setQueryParameter = UrlBuilderSetQueryParameter;
     this.getBase = UrlBuilderGetBase;
     this.getDirectories = UrlBuilderGetDirectories;
     this.getPage = UrlBuilderGetPage;
     this.getQueryParameters = UrlBuilderGetQueryParameters;
     this.getUrl = UrlBuilderGetUrl;
     
     // member variables
     this.base = null;
     this.url = null;
     this.directory = null;
     this.queryParameters = null;
     this.page = null;

     this.setBase(baseUrl);
}

function UrlBuilderSetBase(baseUrl)
{
     // set the base variable to given url
     this.base = baseUrl;
     
     // check for directories
     var dblSlash = this.base.indexOf("//");
     var slash = this.base.indexOf("/",dblSlash+2);
     if ( (slash > 0) && (slash < (this.base.length-1)) )
     {
          this.directory = this.base.substr(slash+1);
          this.base = this.base.substr(0,slash+1);
     }
     
     // check for page
     var parse = new StringParser(this.directory,"/");
     var tok = parse.getTokenAt(parse.getNumberOfTokens()-1);
     if ( tok.indexOf(".") != -1 ) 
     {
          this.page = tok;
          this.directory = this.directory.substr(0,this.directory.indexOf(this.page));
     }
     
     // check for parameters
     if ( this.page.indexOf("?") != -1 ) 
     {
          this.queryParameters = this.page.substr(this.page.indexOf("?") + 1);
          this.page = this.page.substr(0,this.page.indexOf("?"));
     }
}

function UrlBuilderSetDirectory(directory)
{
     // check directory for slashes at the begining and remove it
     if ( (this.directory) && (this.directory.indexOf("/") == 0) ) this.directory = this.directory.substr(1);
     if ( directory.indexOf("/") == 0 ) directory = directory.substr(1);
     
     // check for slash at the end of string and add it
     if ( (this.directory) && (this.directory.charAt(this.directory.length-1) != '/') ) this.directory += "/";
     if ( directory.charAt(directory.length-1) != '/' ) directory += "/";
     
     // set the directory variable
     if ( this.directory ) this.directory += directory;
     else this.directory = directory;
}

function UrlBuilderSetPage(page)
{
     // Check for slashes at the beginning of page
     if ( this.page.indexOf("/") == 0 ) this.page = this.page.substr(1);
     if ( page.indexOf("/") == 0 ) page = page.substr(1);
     
     // set the page variable
     this.page = page;
}

function UrlBuilderSetQueryParameter(key,value)
{
     // check to see if this is first parameter being set
     if ( this.queryParameters ) this.queryParameters += "&" + key + "=" + value;
     else this.queryParameters = key + "=" + value;
}

function UrlBuilderGetBase()
{
     // return the base variable
     return this.base;
}

function UrlBuilderGetDirectories()
{
     // return the directories variable
     return this.directory;
}

function UrlBuilderGetPage()
{
     // return the page variable
     return this.page;
}

function UrlBuilderGetQueryParameters()
{
     // return the query parameters
     return this.queryParameters;
}

function UrlBuilderGetUrl()
{
     // return the concatonated string of base, directories, page, and queryParameters
     this.url = this.base + this.directory + this.page + ((this.queryParameters) ? ("?" + this.queryParameters) : "");
     
     return this.url;
}

//********************************************************************
//********************************************************************
//     OBJECT :     UrlParser
//
//     DESCRIPTION :     This object will parse a given URL.  From this 
//                         URL you can get the individual directories, the
//                         page, the base url, and any query parameters
//********************************************************************
//********************************************************************

function UrlParser(theUrl)
{
     // member functions
     this.setUrl = UrlParserSetUrl;
     this.parse = UrlParserParse;
     this.getUrl = UrlParserGetUrl;
     this.getBaseUrl = UrlParserGetBaseUrl;
     this.getDirectories = UrlParserGetDirectories;
     this.getPage = UrlParserGetPage;
     this.getParameter = UrlParserGetParameter;
     this.getParameterKeys = UrlParserGetParameterKeys;
     
     // member variables
     this.url = theUrl;
     this.base = null;
     this.Directory = null;
     this.page = null;
     this.parameters = null;
}

function UrlParserSetUrl(theUrl)
{
     // set the url variable
     this.url = theUrl;
}

function UrlParserParse()
{
     // extract base url
     var start = 0;
     if ( this.url.indexOf("//") != -1 ) 
     {
          start = this.url.indexOf("//") + 2;
          this.base = this.url.substr(start);
          this.base = this.base.substr(0,this.base.indexOf("/")+1);
     }
     else this.base = this.url.substr(start,this.url.indexOf("/")+1);
     
     // extract directories
     var dirStart = this.base.length + start;
     var parse = new StringParser(this.url.substr(dirStart),"/");
     var tok = null;
     this.directory = "";
     for ( var i = 0; i < parse.getNumberOfTokens(); i++ )
     {
          tok = parse.getTokenAt(i);
          if ( tok.indexOf(".") == -1 )
          {
               this.directory += tok + "/";
          }
     }
     
     // extrace page
     if ( tok ) 
     {
          this.page = tok;
          if ( this.page.indexOf("?") ) this.page = this.page.substr(0,this.page.indexOf("?"));
     }
     
     // extract parameters
     if ( tok.indexOf("?") != -1 ) 
     {
          var param = tok.substr(tok.indexOf("?") + 1);
          var paramParse = new StringParser(param,"&");
          this.parameters = new Array();
          while ( !paramParse.EOT() )
          {
               var token = paramParse.getNextToken();
               var key = token.substr(0,token.indexOf("="));
               this.parameters[key] = token.substr(token.indexOf("=")+1);
          }
     }
}

function UrlParserGetUrl()
{
     // return the url variable
     return this.url;
}

function UrlParserGetBaseUrl()
{
     // determine if base url variable is null 
     if ( this.url )
     {
          if ( !this.base ) this.parse();
     }
          
     // return the base url
     return this.base;
}

function UrlParserGetDirectories()
{
     // determine if directories variable is null
     if ( this.url )
     {
          // if directories is null find first and last occurence of single slash
          if ( !this.base ) this.parse();
     }
     
     // return directories variable
     return this.directory;
}

function UrlParserGetPage()
{
     // determine if page variable is null
     if ( this.url )
     {
          // if directories is null find first and last occurence of single slash
          if ( !this.base ) this.parse();
     }
     
     // return the page variable
     return this.page;
}

function UrlParserGetParameter(key)
{
     // determine if parameters variable is null
     if ( this.url )
     {
          // if directories is null find first and last occurence of single slash
          if ( !this.base ) this.parse();
     }
          
     // return the value of key parameter
     if ( this.parameters ) return this.parameters[key];
     else return null;
}

function UrlParserGetParameterKeys()
{
     var keys = new Array();

     // determine if parameters variable is null
     if ( this.url )
     {
          // if directories is null find first and last occurence of single slash
          if ( !this.base ) this.parse();
     }

     
     for ( var aKey in this.parameters ) keys[keys.length] = aKey;
     
     return keys;
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////LAYER OBJECTS/////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////

//********************************************************************
//********************************************************************
//     OBJECT :     LayerDeminsions
//
//     DESCRIPTION :     This object gets the dimensions of a layer. In other
//                         words it will get/set the height, width, top, left ect..
//********************************************************************
//********************************************************************
function LayerDeminsions(parent)
{
     // member functions
     this.getTop = LayerDeminsionsGetTop;
     this.setTop = LayerDeminsionsSetTop;
     this.getLeft = LayerDeminsionsGetLeft;
     this.setLeft = LayerDeminsionsSetLeft;
     this.getWidth = LayerDeminsionsGetWidth;
     this.setWidth = LayerDeminsionsSetWidth;
     this.getHeight = LayerDeminsionsGetHeight;
     this.setHeight = LayerDeminsionsSetHeight;
     this.setSize = LayerDeminsionsSetSize;
     this.getRectangle = LayerDeminsionsGetRectangle;
     this.setRectangle = LayerDeminsionsSetRectangle;
     this.getPosition = LayerDeminsionsGetPosition;
     this.setPosition = LayerDeminsionsSetPosition;
     
     // member variables
     this.parent = parent;
}

function LayerDeminsionsGetTop()
{
     var top = null;
     
     // make sure parent is set
     if ( this.parent )
     {
          // extract value
          if ( this.parent.browser.isNS4 ) top = this.parent.layer.top;
          else top = this.parent.layer.style.top;

          // make sure value is an integer
          var intTest = new StringManipulator();
          if ( !intTest.isInteger(top) )
          {
               var arInt = intTest.extractIntegers();
               top = arInt[0];
          }
          else top = parseInt(top);
     }
     else alert("This object can only be used with the DynamicLayer Object!");
     
     return top;
}

function LayerDeminsionsSetTop(top)
{
     // make sure parent is set
     if ( this.parent )
     {
          var intTest = new StringManipulator();
          if ( !intTest.isInteger(top) )
          {
               var arInt = intTest.extractIntegers();
               top = arInt[0];
          }
          else top = parseInt(top);
          
          if ( this.parent.browser.isNS4 ) this.parent.layer.top = top;
          else this.parent.layer.style.top = top;
          
     }
     else alert("This object can only be used with the DynamicLayer Object!");
}

function LayerDeminsionsGetLeft()
{
     var left = null;

     // make sure parent is set
     if ( this.parent )
     {
          // extract value
          if ( this.parent.browser.isNS4 ) left = this.parent.layer.left;
          else left = this.parent.layer.style.left;

          // make sure value is an integer
          var intTest = new StringManipulator();
          if ( !intTest.isInteger(left) )
          {
               var arInt = intTest.extractIntegers();
               left = arInt[0];
          }
          else left = parseInt(left);
     }
     else alert("This object can only be used with the DynamicLayer Object!");
     
     return left;
}

function LayerDeminsionsSetLeft(left)
{
     // make sure parent is set
     if ( this.parent )
     {
          // make sure value is an integer
          var intTest = new StringManipulator();
          if ( !intTest.isInteger(left) )
          {
               var arInt = intTest.extractIntegers();
               left = arInt[0];
          }
          else left = parseInt(left);

          // extract value
          if ( this.parent.browser.isNS4 ) this.parent.layer.left = left;
          else this.parent.layer.style.left = left;
     }
     else alert("This object can only be used with the DynamicLayer Object!");
}

function LayerDeminsionsGetWidth()
{
     // create width
     var Width = null;
     
     if ( this.parent )
     {
          if ( this.parent.browser.isNS4 )
          {
               // extract the width
               if ( this.parent.layer.width ) Width = this.parent.layer.width;
               else Width = this.parent.layer.document.width;
          }
          else
          {
               // extract the width
               if ( this.parent.layer.style.width ) Width = this.parent.layer.style.width;
               else Width = this.parent.layer.offsetWidth;
          }

          // make sure width is an integer
          var intTest = new StringManipulator();
          if ( !intTest.isInteger(Width) )
          {
               var arInt = intTest.extractIntegers();
               Width = arInt[0];
          }
          else Width = parseInt(Width);
     }
     else alert("This object can only be used with the DynamicLayer Object!");
     
     // return the width and height
     return Width;
}

function LayerDeminsionsSetWidth(width)
{
     if ( this.parent )
     {
          // make sure width is an integer
          var intTest = new StringManipulator();
          if ( !intTest.isInteger(width) )
          {
               var arInt = intTest.extractIntegers();
               width = arInt[0];
          }
          else width = parseInt(width);

          if ( this.parent.browser.isNS4 ) this.parent.layer.width = width;
          else this.parent.layer.style.width = width;
     }
     else alert("This object can only be used with the DynamicLayer Object!");
}

function LayerDeminsionsGetHeight()
{
     // create Height
     var Height = null;
     
     if ( this.parent )
     {
          if ( this.parent.browser.isNS4 )
          {
               // extract the Height
               if ( this.parent.layer.height ) Height = this.parent.layer.height;
               else Height = this.parent.layer.document.height;
          }
          else
          {
               // extract the width
               if ( this.parent.layer.style.height ) Height = this.parent.layer.style.height;
               else Height = this.parent.layer.offsetHeight;
          }

          // make sure width is an integer
          var intTest = new StringManipulator();
          if ( !intTest.isInteger(Height) )
          {
               var arInt = intTest.extractIntegers();
               Height = arInt[0];
          }
          else Height = parseInt(Height);
     }
     else alert("This object can only be used with the DynamicLayer Object!");
     
     // return the width and height
     return Height;
}

function LayerDeminsionsSetHeight(height)
{
     if ( this.parent )
     {
          // make sure width is an integer
          var intTest = new StringManipulator();
          if ( !intTest.isInteger(height) )
          {
               var arInt = intTest.extractIntegers();
               height = arInt[0];
          }
          else height = parseInt(height);

          if ( this.parent.browser.isNS4 ) this.parent.layer.height = height;
          else this.parent.layer.style.height = height;
     }
     else alert("This object can only be used with the DynamicLayer Object!");
}

function LayerDeminsionsSetSize(width,height)
{
     if ( this.parent )
     {
          this.setWidth(width);
          this.setHeight(height);
     }
     else alert("This object can only be used with the DynamicLayer Object!");
}

function LayerDeminsionsGetRectangle()
{
     var rect = new Object();

     if ( this.parent )
     {
          rect.width = this.getWidth();
          rect.height = this.getHeight();
          rect.top = this.getTop();
          rect.left = this.getLeft();
     }
     else alert("This object can only be used with the DynamicLayer Object!");
     
     return rect;
}

function LayerDeminsionsSetRectangle(x,y,width,height)
{
     if ( this.parent )
     {
          this.setLeft(x);
          this.setTop(y);
          this.setWidth(width);
          this.setHeight(height);
     }
     else alert("This object can only be used with the DynamicLayer Object!");
}

function LayerDeminsionsGetPosition()
{
     var pos = new Object();
     
     if ( this.parent )
     {
          pos.Y = this.getTop();
          pos.X = this.getLeft();
     }
     else alert("This object can only be used with the DynamicLayer Object!");

     return pos;     
}

function LayerDeminsionsSetPosition(x,y)
{
     if ( this.parent )
     {
          this.setLeft(x);
          this.setTop(y);
     }
     else alert("This object can only be used with the DynamicLayer Object!");
}

//********************************************************************
//********************************************************************
//     OBJECT :     LayerStyle
//
//     DESCRIPTION :     This object gets/sets the style of the layer. It
//                         also includes some basic functions to do common
//                         layer styles.
//********************************************************************
//********************************************************************
function LayerStyle(parent)
{
     // member functions
     this.setStyle = LayerStyleSetStyle;
     this.setClip = LayerStyleSetClip;
     this.setBackground = LayerStyleSetBackground;
     this.setFontColor = LayerStyleSetFontColor;
     this.setCursor = LayerStyleSetCursor;
     
     // member variables
     this.parent = parent;
}

function LayerStyleSetStyle(style,value)
{
     if ( this.parent )
     {
          if ( this.parent.browser.isNS4 )
          {
               // if a style is given in DOM format, move to Netscape 4.7 format
               // otherwise just set the style
               if ( style == "background-color" ) eval("this.parent.layer.bgColor = \"" + value + "\"");
               else if ( style == "clip" )
               {
                    var theClipValues = style.substr(value.indexOf("(")+1);
                    theClipValues = theClipValues.substr(0,theClipValues.indexOf(")"));
                    var parse = new StringParser(theClipValues," ");
                    this.parent.layer.clip.left = parse.getTokenAt(3);
                    this.parent.layer.clip.top = parse.getTokenAt(0);
                    this.parent.layer.clip.right = parse.getTokenAt(1);
                    this.parent.layer.clip.bottom = parse.getTokenAt(2);
               }
               else eval("this.parent.layer." + style + " = \"" + value + "\"");
          }
          else
          {
               // set the style
               eval("this.parent.layer.style." + style + " = \"" + value + "\"");
          }
     }
     else alert("his object can only be used with the DynamicLayer Object!");
}

function LayerStyleSetClip(top,right,bottom,left)
{
     if ( this.parent )
     {
          if ( this.parent.browser.isNS4 )
          {
               this.parent.layer.clip.left = left;
               this.parent.layer.clip.right = right;
               this.parent.layer.clip.top = top;
               this.parent.layer.clip.bottom = bottom;
          }
          else
          {
               this.parent.layer.style.clip = "rect(" + top + " " + right + " " + bottom + " " + left + ")";
          }
     }
     else alert("his object can only be used with the DynamicLayer Object!");
}

function LayerStyleSetBackground(color)
{
     if ( this.parent )
     {
          if ( this.parent.browser.isNS4 ) this.parent.layer.bgColor = color;
          else this.parent.layer.style.backgroundColor = color;
     }
     else alert("his object can only be used with the DynamicLayer Object!");
}

function LayerStyleSetFontColor(color)
{
     if ( this.parent )
     {
          if ( this.parent.browser.isNS4 ) this.parent.layer.fgColor = color;
          else this.parent.layer.style.color = color;
     }
     else alert("his object can only be used with the DynamicLayer Object!");
}

function LayerStyleSetCursor(cursor)
{
     if ( this.parent )
     {
          if ( this.parent.browser.isNS4 ) this.parent.layer.cursor = cursor;
          else this.parent.layer.style.cursor = cursor;
     }
     else alert("his object can only be used with the DynamicLayer Object!");
}

//****************************************************************
//****************************************************************
//     OBJECT :          DriftLayer
//
//     DESCRIPTION :     This object will drift a layer at the given
//                         coordinates of a page
//****************************************************************
//***************************************************************

// Global Tracking
DriftLayer.index = 0;
DriftLayer.all = new Array();
DriftLayer.NORMAL = 0;
DriftLayer.IN_PLACE = 1;

function DriftLayer(parent)
{
     // member functions
     this.start = DriftLayerStart;
     this.stop = DriftLayerStop;
     this.setDriftType = DriftLayerSetDriftType;
     this.driftCheckInterval = DriftLayerDriftCheckInterval;
     this.setOffsets = DriftLayerSetOffsets;
     this.setTop = DriftLayerSetTop;
     this.checkDrift = DriftLayerCheckDrift;
     
     // member variables
     this.b = new Browser();
     this.timer = new Timer(Timer.INTERVAL_TIMER);
     this.parent = parent;
     if ( this.parent ) this.layer = this.parent.layer;
     else this.layer = null;
     this.currentPoint = new Object();
     this.currentPoint.X = 0;
     this.currentPoint.Y = 0;
     this.screen = new Application();
     this.offsetTop = 0;
     this.offsetBottom = 0;
     this.topLocation = 0;
     this.driftType = DriftLayer.NORMAL;
     this.name = "DriftLayer" + DriftLayer.index++;
     this.obj = this.name;
     
     // set global tracking
     eval(this.obj + " = this");
     DriftLayer.all[DriftLayer.all.length] = this;
}

function DriftLayerStart()
{
     if ( !this.timer.isTimerRunning() ) this.timer.startTimer();
}

function DriftLayerStop()
{
     if ( this.timer.isTimerRunning() ) this.timer.stopTimer();
}

function DriftLayerSetDriftType(dtype)
{
     this.driftType = dtype;
}

function DriftLayerDriftCheckInterval(ms)
{
     this.timer.setTimer(ms,this.obj + ".checkDrift()");
}

function DriftLayerSetOffsets(top,bot)
{
     this.offsetTop = top;
     this.offsetBottom = bot;
}

function DriftLayerSetTop(top)
{
     this.topLocation = top;
}

function DriftLayerCheckDrift()
{
     if ( this.layer ) 
     {
          if ( this.driftType == DriftLayer.NORMAL )
          {
               var screenBottomY = this.screen.workingDocument.getTop() + this.screen.display.getHeight();
               var rect = this.parent.dimensions.getRectangle();
               var bottomY = rect.top + rect.height;
               
               var bListGWS = false;
               var totalHeight = rect.height + this.offsetTop + this.offsetBottom;
               if ( totalHeight > this.screen.display.getHeight() ) bListGWS = true;
               
               
               if ( this.screen.workingDocument.getTop() < this.topLocation )
               {
                    this.parent.dimensions.setPosition(rect.left,this.topLocation);
               }
               else if ( this.screen.workingDocument.getTop() < this.currentPoint.Y ) // scrolling up
               {
                    // check bottom of list for visibility
                    if ( rect.top > (this.screen.workingDocument.getTop() + this.offsetTop) )
                    {
                         var delta = rect.top - (this.screen.workingDocument.getTop() + this.offsetTop);
                         // move list up to offset
                         this.parent.dimensions.setPosition(rect.left,(rect.top - delta));
                    }
                    
               }
               else if ( this.screen.workingDocument.getTop() > this.currentPoint.Y ) // scrolling down
               {
                    if ( !bListGWS )
                    {
                         var delta = (this.screen.workingDocument.getTop() + this.offsetTop) - rect.top;
                         
                         this.parent.dimensions.setPosition(rect.left,(rect.top + delta));
                    }
                    else if ( bottomY < (screenBottomY - this.offsetBottom) )
                    {
                         var delta = (screenBottomY - this.offsetBottom) - bottomY;

                         // move list to offset
                         this.parent.dimensions.setPosition(rect.left,(bottomY + delta));
                    }
               }
               
               this.currentPoint.Y = this.screen.workingDocument.getTop();
               this.currentPoint.X = this.screen.workingDocument.getLeft();
          }
          else
          {
               var rect = this.parent.dimensions.getRectangle();
               var dif = this.screen.workingDocument.getTop() - this.currentPoint.Y;
               this.parent.dimensions.setPosition(rect.left,rect.top + dif);
               this.currentPoint.Y = this.screen.workingDocument.getTop();
               this.currentPoint.X = this.screen.workingDocument.getLeft();
          }
     }
}

//********************************************************************
//********************************************************************
//     OBJECT :     DynamicLayer
//
//     DESCRIPTION :     This object contains all the objects described
//                         above in this section.  It is an object that helps
//                         to control the aspects of a layer on a web page.
//********************************************************************
//********************************************************************

function DynamicLayer(id,parent)
{
     // member functions
     this.show = DynamicLayerShow;
     this.isVisible = DynamicLayerIsVisible;
     this.enableDrift = DyanmicLayerEnableDrift;
     this.findLayer = DynamicLayerFindLayer;
     
     // member variables
     this.parent = parent;
     this.id = id;
     this.browser = new Browser(this);
     this.layer = this.findLayer(id,parent);
     this.dimensions = new LayerDeminsions(this);
     this.style = new LayerStyle(this);
     this.drift = new DriftLayer(this);
     this.events = new EventScheduler(this.layer);
     this.bVisible = -1;
}

function DynamicLayerShow(bShow)
{
     if ( this.layer )
     {
          if ( this.browser.isNS4 ) this.layer.visibility = (bShow) ? "inherit" : "hidden";
          else this.layer.style.visibility = (bShow) ? "inherit" : "hidden";
          
          this.bVisible = bShow;
     }
     else alert("Layer is not set!");
}

function DynamicLayerIsVisible()
{
     if ( this.bVisible == -1 )
     {
          if ( this.browser.isNS4 && (this.layer.visibility == "inherit") ) this.bVisible = true;
          else if ( !this.browser.isNS4 && (this.layer.style.visibility == "inherit") ) this.bVisible = true;
          else this.bVisible = false;
     }
     
     return this.bVisible;
}

function DyanmicLayerEnableDrift(bEnable)
{
     if ( bEnable ) this.drift.start();
     else this.drift.stop();
}

function DynamicLayerFindLayer(id,parent)
{
     var layer = null;
     
     if ( this.browser.isNS4 )
     {
          if ( (parent == document) || (parent == null) ) layer = document.layers[id];
          else layer = parent.document.layers[id];
     }
     else layer = document.getElementById(id);
     
     return layer;
}



//-------------------------------------- END OF FILE ---------------------------------------------------------

